//

// Fragment shader for creating a fuzzy black rim  in the texture
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform sampler2DRect inTexUnit;
uniform sampler2DRect outTexUnit;

uniform vec4 textureRect;
uniform vec4 textureRect2;

uniform int hasTextureIn;  // 0 = no texture in, 1 = has texture in 
uniform int hasTextureOut;  // 0 = no texture in, 1 = has texture in 

uniform float centerX; 
uniform float centerY;  
uniform float maskBandWidth; 
uniform float outerBound; 
uniform float innerBound; 

uniform int isScreenRendered; // 0 - NO, 1 - YES
uniform float clearScreenR; 
uniform float clearScreenG; 
uniform float clearScreenB; 
uniform float clearScreenA; 
uniform  vec4 modulateColor;
varying vec2 gUV;
varying vec2 gUV2; 

void main(void)
{
    // Get three texture colors
    vec4 screenTexColor;
    
    if (isScreenRendered == 1)
        screenTexColor = texture2DRect(texUnit,gUV);
    else 
        screenTexColor = vec4(clearScreenR, clearScreenG, clearScreenB, clearScreenA); 

    vec4 inTexColor = screenTexColor;
    if ( hasTextureIn ==1)
        inTexColor = texture2DRect(inTexUnit, gUV);
    
    vec4 outTexColor = screenTexColor;
    if ( hasTextureOut ==1 )
        outTexColor = texture2DRect(outTexUnit, gUV2);

   if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
       inTexColor = screenTexColor;
    if ( gUV2.x< textureRect2.x || gUV2.x> textureRect2.x+textureRect2.z || gUV2.y < textureRect2.y || gUV2.y > textureRect2.y+textureRect2.w ) 
        outTexColor = screenTexColor;

    // ouput color
    vec4 outputColor;
    
    // This pixel location 	
    vec3 pCoord = gl_FragCoord.xyz;
    
    // Calculate the distance from this pixel to the center 
    float distance =sqrt(pow(pCoord.x-centerX, 2.0) +pow(pCoord.y-centerY,2.0)); 
    float ratio = 1.0; 
        
    // First blend the in/out texture colors. 
    if ( distance <= outerBound && distance >= innerBound) {

        // blend two textures based on inside the rim. On the inner end is inTexture, on the outer end is outTexture. 
        ratio = (outerBound-distance)/maskBandWidth;
        outputColor = mix(outTexColor, inTexColor, ratio); 
    } 
    else if ( distance < innerBound ) 
        outputColor = inTexColor; 
        //outputColor  = vec4(0.0,0.0,1.0,1.0);
    else if ( distance > outerBound )
        outputColor = outTexColor; 
        //outputColor  = vec4(1.0,0.0,0.0,1.0);
    else 
        //outputColor  = vec4(0.0,1.0,1.0,1.0);
        outputColor = screenTexColor; 
        
    gl_FragColor = modulateColor * outputColor;

}
